/*
 * Decompiled with CFR 0.152.
 */
package dev.doctor4t.wathe.datagen;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import dev.doctor4t.wathe.Wathe;
import dev.doctor4t.wathe.block.BarBlock;
import dev.doctor4t.wathe.block.BranchBlock;
import dev.doctor4t.wathe.block.CabinetBlock;
import dev.doctor4t.wathe.block.CargoBoxBlock;
import dev.doctor4t.wathe.block.CouchBlock;
import dev.doctor4t.wathe.block.DiagonalRailingBlock;
import dev.doctor4t.wathe.block.LedgeBlock;
import dev.doctor4t.wathe.block.NeonPillarBlock;
import dev.doctor4t.wathe.block.NeonTubeBlock;
import dev.doctor4t.wathe.block.OrnamentBlock;
import dev.doctor4t.wathe.block.PanelStripesBlock;
import dev.doctor4t.wathe.block.PrivacyGlassBlock;
import dev.doctor4t.wathe.block.PrivacyGlassPanelBlock;
import dev.doctor4t.wathe.block.TrimmedBedBlock;
import dev.doctor4t.wathe.block.TrimmedLanternBlock;
import dev.doctor4t.wathe.block.TrimmedStairsBlock;
import dev.doctor4t.wathe.block.VentHatchBlock;
import dev.doctor4t.wathe.block.WalkwayBlock;
import dev.doctor4t.wathe.block.WallLampBlock;
import dev.doctor4t.wathe.block.property.CouchArms;
import dev.doctor4t.wathe.block.property.RailingShape;
import dev.doctor4t.wathe.index.WatheBlocks;
import dev.doctor4t.wathe.index.WatheItems;
import dev.doctor4t.wathe.item.KnifeItem;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2341;
import net.minecraft.class_2350;
import net.minecraft.class_2429;
import net.minecraft.class_2738;
import net.minecraft.class_2741;
import net.minecraft.class_2742;
import net.minecraft.class_2746;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4918;
import net.minecraft.class_4922;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4938;
import net.minecraft.class_4940;
import net.minecraft.class_4941;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_4946;
import net.minecraft.class_5794;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class WatheModelGen
extends FabricModelProvider {
    protected static final class_4942 THICK_BAR = new class_4942(Optional.of(Wathe.id("block/template_thick_bar")), Optional.empty(), new class_4945[]{class_4945.field_23011});
    protected static final class_4942 THICK_BAR_TOP = new class_4942(Optional.of(Wathe.id("block/template_thick_bar_top")), Optional.of("_top"), new class_4945[]{class_4945.field_23011});
    protected static final class_4942 THICK_BAR_BOTTOM = new class_4942(Optional.of(Wathe.id("block/template_thick_bar_bottom")), Optional.of("_bottom"), new class_4945[]{class_4945.field_23011});
    private static final class_4945 SPYGLASS_KEY = class_4945.method_27043((String)"spyglass");
    private static final class_4945 SHELF_KEY = class_4945.method_27043((String)"shelf");
    private static final class_4942 BRANCH_FACE = WatheModelGen.template("block/template_branch_face", "_face", class_4945.field_23018);
    private static final class_4942 BRANCH_FACE_HORIZONTAL = WatheModelGen.template("block/template_branch_face_horizontal", "_face_horizontal", class_4945.field_23018);
    private static final class_4942 BRANCH_FRONT = WatheModelGen.template("block/template_branch_front", "_front", class_4945.field_23015, class_4945.field_23018);
    private static final class_4942 BRANCH_BACK = WatheModelGen.template("block/template_branch_back", "_back", class_4945.field_23015, class_4945.field_23018);
    private static final class_4942 BRANCH_INVENTORY = WatheModelGen.template("block/template_branch_inventory", "_inventory", class_4945.field_23015, class_4945.field_23018);
    private static final class_4942 VENT_SHAFT_SIDE = WatheModelGen.template("block/template_vent_shaft_side", class_4945.field_23018, class_4945.field_27791);
    private static final class_4942 VENT_SHAFT_SIDE_VERTICAL = WatheModelGen.template("block/template_vent_shaft_side_vertical", "_side_vertical", class_4945.field_23018, class_4945.field_27791);
    private static final class_4942 VENT_SHAFT_SIDE_OPENING = WatheModelGen.template("block/template_vent_shaft_side_opening", "_side_opening", class_4945.field_23018);
    private static final class_4942 VENT_SHAFT_INVENTORY = WatheModelGen.template("block/template_vent_shaft_inventory", "_inventory", class_4945.field_23018, class_4945.field_23013, class_4945.field_27791);
    private static final class_4942 WALKWAY_TOP = WatheModelGen.template("block/template_walkway_top", "_top", class_4945.field_23018, class_4945.field_23015);
    private static final class_4942 WALKWAY_BOTTOM = WatheModelGen.template("block/template_walkway_bottom", "_bottom", class_4945.field_23018, class_4945.field_23015);
    private static final class_4942 LOUNGE_COUCH_LEFT = WatheModelGen.template("block/template_lounge_couch_left", "_left", class_4945.field_23011);
    private static final class_4942 LOUNGE_COUCH_RIGHT = WatheModelGen.template("block/template_lounge_couch_right", "_right", class_4945.field_23011);
    private static final class_4942 LOUNGE_COUCH_SINGLE = WatheModelGen.template("block/template_lounge_couch_single", "_single", class_4945.field_23011);
    private static final class_4942 LOUNGE_COUCH_NO_ARMS = WatheModelGen.template("block/template_lounge_couch_no_arms", "_no_arms", class_4945.field_23011);
    private static final class_4942 TRIMMED_STAIR_SUPPORT = WatheModelGen.template("block/template_trimmed_stair_support", "_support", class_4945.field_23011);
    private static final class_4942 TRIMMED_STAIRS = WatheModelGen.template("block/template_trimmed_stairs", class_4945.field_23011);
    private static final class_4942 PANEL = WatheModelGen.template("block/template_panel", class_4945.field_23010);
    private static final class_4942 LADDER = WatheModelGen.template(class_2960.method_60656((String)"block/ladder"), class_4945.field_23011, class_4945.field_23012);
    private static final class_4942 TRIMMED_LANTERN_FLOOR = WatheModelGen.template("block/template_trimmed_lantern_floor", class_4945.field_23015, class_4945.field_23014, class_4945.field_23018);
    private static final class_4942 TRIMMED_LANTERN_CEILING = WatheModelGen.template("block/template_trimmed_lantern_ceiling", class_4945.field_23015, class_4945.field_23014, class_4945.field_23018);
    private static final class_4942 TRIMMED_LANTERN_WALL = WatheModelGen.template("block/template_trimmed_lantern_wall", class_4945.field_23015, class_4945.field_23014, class_4945.field_23018);
    private static final class_4942 WALL_LAMP_FLOOR = WatheModelGen.template("block/template_wall_lamp_floor", class_4945.field_23011);
    private static final class_4942 WALL_LAMP_CEILING = WatheModelGen.template("block/template_wall_lamp_ceiling", class_4945.field_23011);
    private static final class_4942 WALL_LAMP_WALL = WatheModelGen.template("block/template_wall_lamp_wall", class_4945.field_23011);
    private static final class_4942 CARGO_BOX = WatheModelGen.template("block/template_cargo_box", class_4945.field_23015, class_4945.field_23018, class_4945.field_23014);
    private static final class_4942 CARGO_BOX_OPEN = WatheModelGen.template("block/template_cargo_box_open", "_open", class_4945.field_23015, class_4945.field_23018, class_4945.field_23014);
    private static final class_4942 CABINET_OPEN = WatheModelGen.template("block/template_cabinet_open", "_open", class_4945.field_23016, class_4945.field_23018, class_4945.field_23027, SHELF_KEY);
    private static final class_4942 GLASS_PANEL = WatheModelGen.template("block/template_glass_panel", class_4945.field_23031, class_4945.field_23032);
    private static final class_4942 LEATHER_COUCH_LEFT = WatheModelGen.template("block/template_leather_couch_left", "_left", class_4945.field_23011);
    private static final class_4942 LEATHER_COUCH_RIGHT = WatheModelGen.template("block/template_leather_couch_right", "_right", class_4945.field_23011);
    private static final class_4942 LEATHER_COUCH = WatheModelGen.template("block/template_leather_couch", class_4945.field_23011);
    private static final class_4942 LEATHER_COUCH_MIDDLE = WatheModelGen.template("block/template_leather_couch_middle", "_middle", class_4945.field_23011);
    private static final class_4942 ORNAMENT_R0 = WatheModelGen.template("block/template_ornament_r0", class_4945.field_23011);
    private static final class_4942 ORNAMENT_R90 = WatheModelGen.template("block/template_ornament_r90", class_4945.field_23011);
    private static final class_4942 ORNAMENT_R180 = WatheModelGen.template("block/template_ornament_r180", class_4945.field_23011);
    private static final class_4942 ORNAMENT_R270 = WatheModelGen.template("block/template_ornament_r270", class_4945.field_23011);
    private static final class_4942 LEDGE = WatheModelGen.template("block/template_ledge", class_4945.field_23011);
    private static final class_4942 BAR = WatheModelGen.template("block/template_bar", class_4945.field_23011);
    private static final class_4942 BAR_TOP = WatheModelGen.template("block/template_bar_top", "_top", class_4945.field_23011);
    private static final class_4942 BAR_BOTTOM = WatheModelGen.template("block/template_bar_bottom", "_bottom", class_4945.field_23011);
    private static final class_4942 TRIMMED_BED_FOOT = WatheModelGen.template("block/template_trimmed_bed_foot", "_foot", class_4945.field_23011);
    private static final class_4942 TRIMMED_BED_HEAD = WatheModelGen.template("block/template_trimmed_bed_head", "_head", class_4945.field_23011);
    private static final class_4942 TRIMMED_BED_INVENTORY = WatheModelGen.template("block/template_trimmed_bed_inventory", "_inventory", class_4945.field_23011);
    private static final class_4942 SPRINKLER = WatheModelGen.template("block/template_sprinkler", class_4945.field_23011, class_4945.field_23012);
    private static final class_4942 VENT_HATCH = WatheModelGen.template("block/template_vent_hatch", class_4945.field_23011);
    private static final class_4942 VENT_HATCH_OPEN = WatheModelGen.template("block/template_vent_hatch_open", "_open", class_4945.field_23011);
    private final Map<class_2248, class_4946> uniqueModels = ImmutableMap.builder().build();
    public static final class_4942 SMALL_ITEM = WatheModelGen.item("small_item", class_4945.field_23006);
    public static final class_4942 KNIFE_TEMPLATE = WatheModelGen.model("item/template_knife", "_in_hand", class_4945.field_23006);

    public WatheModelGen(FabricDataOutput output) {
        super(output);
    }

    private static class_4942 template(class_2960 parent, @Nullable String variant, class_4945 ... requiredTextureKeys) {
        return new class_4942(Optional.of(parent), Optional.ofNullable(variant), requiredTextureKeys);
    }

    private static class_4942 template(class_2960 parent, class_4945 ... requiredTextureKeys) {
        return WatheModelGen.template(parent, null, requiredTextureKeys);
    }

    private static class_4942 template(String parentName, @Nullable String variant, class_4945 ... requiredTextureKeys) {
        return WatheModelGen.template(Wathe.id(parentName), variant, requiredTextureKeys);
    }

    private static class_4942 template(String parentName, class_4945 ... requiredTextureKeys) {
        return WatheModelGen.template(Wathe.id(parentName), requiredTextureKeys);
    }

    public void generateBlockStateModels(class_4910 generator) {
        this.registerVentShaft(generator, WatheBlocks.STAINLESS_STEEL_VENT_SHAFT);
        this.registerVentHatch(generator, WatheBlocks.STAINLESS_STEEL_VENT_HATCH);
        this.registerVentShaft(generator, WatheBlocks.DARK_STEEL_VENT_SHAFT);
        this.registerVentHatch(generator, WatheBlocks.DARK_STEEL_VENT_HATCH);
        this.registerVentShaft(generator, WatheBlocks.TARNISHED_GOLD_VENT_SHAFT);
        this.registerVentHatch(generator, WatheBlocks.TARNISHED_GOLD_VENT_HATCH);
        this.registerFamily(generator, WatheBlocks.Family.TARNISHED_GOLD);
        this.registerFamily(generator, WatheBlocks.Family.GOLD);
        this.registerFamily(generator, WatheBlocks.Family.PRISTINE_GOLD);
        generator.method_25554(WatheBlocks.TARNISHED_GOLD_PILLAR, class_4946.field_23055, class_4946.field_23056);
        generator.method_25554(WatheBlocks.GOLD_PILLAR, class_4946.field_23055, class_4946.field_23056);
        generator.method_25554(WatheBlocks.PRISTINE_GOLD_PILLAR, class_4946.field_23055, class_4946.field_23056);
        this.registerFamily(generator, WatheBlocks.Family.METAL_SHEET);
        generator.method_25658(WatheBlocks.COCKPIT_DOOR);
        this.registerWalkway(generator, WatheBlocks.METAL_SHEET_WALKWAY);
        this.registerLadder(generator, WatheBlocks.STAINLESS_STEEL_LADDER);
        this.registerFamily(generator, WatheBlocks.Family.STAINLESS_STEEL);
        this.registerWalkway(generator, WatheBlocks.STAINLESS_STEEL_WALKWAY);
        this.registerBranch(generator, WatheBlocks.STAINLESS_STEEL_BRANCH, WatheBlocks.STAINLESS_STEEL);
        generator.method_25554(WatheBlocks.STAINLESS_STEEL_PILLAR, class_4946.field_23055, class_4946.field_23056);
        this.registerFamily(generator, WatheBlocks.Family.DARK_STEEL);
        this.registerWalkway(generator, WatheBlocks.DARK_STEEL_WALKWAY);
        this.registerBranch(generator, WatheBlocks.DARK_STEEL_BRANCH, WatheBlocks.DARK_STEEL);
        generator.method_25554(WatheBlocks.DARK_STEEL_PILLAR, class_4946.field_23055, class_4946.field_23056);
        generator.method_25641(WatheBlocks.RHOMBUS_GLASS);
        this.registerGlassPanel(generator, WatheBlocks.GOLDEN_GLASS_PANEL);
        this.registerCullingGlass(generator);
        this.registerFamily(generator, WatheBlocks.Family.MARBLE);
        this.registerFamily(generator, WatheBlocks.Family.MARBLE_TILE);
        this.registerFamily(generator, WatheBlocks.Family.DARK_MARBLE);
        generator.method_25614(class_4946.field_23045, new class_2248[]{WatheBlocks.MARBLE_MOSAIC});
        this.registerFamily(generator, WatheBlocks.Family.WHITE_HULL);
        this.registerCulledBlock(generator, WatheBlocks.CULLING_WHITE_HULL, WatheBlocks.WHITE_HULL);
        this.registerFamily(generator, WatheBlocks.Family.BLACK_HULL);
        this.registerCulledBlock(generator, WatheBlocks.CULLING_BLACK_HULL, WatheBlocks.BLACK_HULL);
        this.registerFamily(generator, WatheBlocks.Family.BLACK_HULL_SHEET);
        this.registerFamily(generator, WatheBlocks.Family.MAHOGANY);
        this.registerFamily(generator, WatheBlocks.Family.MAHOGANY_HERRINGBONE);
        this.registerFamily(generator, WatheBlocks.Family.SMOOTH_MAHOGANY);
        this.registerPanel(generator, WatheBlocks.MAHOGANY_PANEL, WatheBlocks.SMOOTH_MAHOGANY);
        this.registerCabinet(generator, WatheBlocks.MAHOGANY_CABINET);
        this.registerVariedBookshelf(generator, WatheBlocks.MAHOGANY_BOOKSHELF, WatheBlocks.MAHOGANY_PLANKS);
        this.registerFamily(generator, WatheBlocks.Family.BUBINGA);
        this.registerFamily(generator, WatheBlocks.Family.BUBINGA_HERRINGBONE);
        this.registerFamily(generator, WatheBlocks.Family.SMOOTH_BUBINGA);
        this.registerPanel(generator, WatheBlocks.BUBINGA_PANEL, WatheBlocks.SMOOTH_BUBINGA);
        this.registerCabinet(generator, WatheBlocks.BUBINGA_CABINET);
        this.registerVariedBookshelf(generator, WatheBlocks.BUBINGA_BOOKSHELF, WatheBlocks.BUBINGA_PLANKS);
        this.registerFamily(generator, WatheBlocks.Family.EBONY);
        this.registerFamily(generator, WatheBlocks.Family.EBONY_HERRINGBONE);
        this.registerFamily(generator, WatheBlocks.Family.SMOOTH_EBONY);
        this.registerPanel(generator, WatheBlocks.EBONY_PANEL, WatheBlocks.SMOOTH_EBONY);
        this.registerCabinet(generator, WatheBlocks.EBONY_CABINET);
        this.registerTrimmedStairs(generator, WatheBlocks.TRIMMED_EBONY_STAIRS);
        this.registerVariedBookshelf(generator, WatheBlocks.EBONY_BOOKSHELF, WatheBlocks.EBONY_PLANKS);
        this.registerBranch(generator, WatheBlocks.OAK_BRANCH, class_2246.field_10431);
        this.registerBranch(generator, WatheBlocks.SPRUCE_BRANCH, class_2246.field_10037);
        this.registerBranch(generator, WatheBlocks.BIRCH_BRANCH, class_2246.field_10511);
        this.registerBranch(generator, WatheBlocks.JUNGLE_BRANCH, class_2246.field_10306);
        this.registerBranch(generator, WatheBlocks.ACACIA_BRANCH, class_2246.field_10533);
        this.registerBranch(generator, WatheBlocks.DARK_OAK_BRANCH, class_2246.field_10010);
        this.registerBranch(generator, WatheBlocks.MANGROVE_BRANCH, class_2246.field_37545);
        this.registerBranch(generator, WatheBlocks.CHERRY_BRANCH, class_2246.field_42729);
        this.registerPole(generator, WatheBlocks.BAMBOO_POLE, class_2246.field_41072);
        this.registerBranch(generator, WatheBlocks.CRIMSON_STIPE, class_2246.field_22118);
        this.registerBranch(generator, WatheBlocks.WARPED_STIPE, class_2246.field_22111);
        this.registerBranch(generator, WatheBlocks.STRIPPED_OAK_BRANCH, class_2246.field_10519);
        this.registerBranch(generator, WatheBlocks.STRIPPED_SPRUCE_BRANCH, class_2246.field_10436);
        this.registerBranch(generator, WatheBlocks.STRIPPED_BIRCH_BRANCH, class_2246.field_10366);
        this.registerBranch(generator, WatheBlocks.STRIPPED_JUNGLE_BRANCH, class_2246.field_10254);
        this.registerBranch(generator, WatheBlocks.STRIPPED_ACACIA_BRANCH, class_2246.field_10622);
        this.registerBranch(generator, WatheBlocks.STRIPPED_DARK_OAK_BRANCH, class_2246.field_10244);
        this.registerBranch(generator, WatheBlocks.STRIPPED_MANGROVE_BRANCH, class_2246.field_37548);
        this.registerBranch(generator, WatheBlocks.STRIPPED_CHERRY_BRANCH, class_2246.field_42732);
        this.registerPole(generator, WatheBlocks.STRIPPED_BAMBOO_POLE, class_2246.field_41073);
        this.registerBranch(generator, WatheBlocks.STRIPPED_CRIMSON_STIPE, class_2246.field_22119);
        this.registerBranch(generator, WatheBlocks.STRIPPED_WARPED_STIPE, class_2246.field_22112);
        this.registerHorizontalAxisBlock(generator, WatheBlocks.PANEL_STRIPES, false);
        this.registerHorizontalAxisBlock(generator, WatheBlocks.RAIL_BEAM, true);
        this.registerRailing(generator, WatheBlocks.TRIMMED_RAILING, WatheBlocks.TRIMMED_RAILING_POST, WatheBlocks.DIAGONAL_TRIMMED_RAILING);
        this.registerCargoBox(generator, WatheBlocks.CARGO_BOX);
        this.registerLoungeCouch(generator, WatheBlocks.WHITE_LOUNGE_COUCH);
        generator.method_25708(WatheBlocks.WHITE_OTTOMAN);
        this.registerBed(generator, WatheBlocks.WHITE_TRIMMED_BED);
        this.registerBed(generator, WatheBlocks.RED_TRIMMED_BED);
        this.registerLoungeCouch(generator, WatheBlocks.BLUE_LOUNGE_COUCH);
        this.registerLoungeCouch(generator, WatheBlocks.GREEN_LOUNGE_COUCH);
        this.registerLeatherCouch(generator, WatheBlocks.RED_LEATHER_COUCH);
        this.registerLeatherCouch(generator, WatheBlocks.BROWN_LEATHER_COUCH);
        this.registerLeatherCouch(generator, WatheBlocks.BEIGE_LEATHER_COUCH);
        generator.method_25681(WatheBlocks.COFFEE_TABLE);
        generator.method_25681(WatheBlocks.BAR_TABLE);
        generator.method_25681(WatheBlocks.BAR_STOOL);
        this.registerBar(generator, WatheBlocks.GOLD_BAR);
        this.registerLedge(generator, WatheBlocks.GOLD_LEDGE, WatheBlocks.GOLD_BAR);
        this.registerBar(generator, WatheBlocks.STAINLESS_STEEL_BAR);
        this.registerTrimmedLantern(generator, WatheBlocks.TRIMMED_LANTERN, false);
        this.registerWallLamp(generator, WatheBlocks.WALL_LAMP, false);
        this.registerNeonPillar(generator, WatheBlocks.NEON_PILLAR, false);
        this.registerNeonTube(generator, WatheBlocks.NEON_TUBE, false);
        this.registerSprinkler(generator, WatheBlocks.STAINLESS_STEEL_SPRINKLER, WatheBlocks.STAINLESS_STEEL);
        this.registerSprinkler(generator, WatheBlocks.GOLD_SPRINKLER, WatheBlocks.GOLD);
        this.registerButton(generator, WatheBlocks.SMALL_BUTTON);
        this.registerButton(generator, WatheBlocks.ELEVATOR_BUTTON);
        this.registerOrnament(generator, WatheBlocks.GOLD_ORNAMENT);
        this.registerParticleBlockWithItemSprite(generator, WatheBlocks.SMALL_WOOD_DOOR, WatheBlocks.SMOOTH_EBONY);
        this.registerParticleBlockWithItemSprite(generator, WatheBlocks.SMALL_GLASS_DOOR, WatheBlocks.TARNISHED_GOLD_PILLAR);
        this.registerHullGlass(generator, WatheBlocks.HULL_GLASS);
        generator.method_25641(WatheBlocks.RHOMBUS_HULL_GLASS);
        this.registerPrivacyGlassPanel(generator, WatheBlocks.PRIVACY_GLASS_PANEL);
        this.registerFancySteel(generator, WatheBlocks.ANTHRACITE_STEEL, WatheBlocks.SMOOTH_ANTHRACITE_STEEL, WatheBlocks.ANTHRACITE_STEEL_TILES, WatheBlocks.ANTHRACITE_STEEL_PANEL, WatheBlocks.ANTHRACITE_STEEL_TILES_PANEL, WatheBlocks.SMOOTH_ANTHRACITE_STEEL_PANEL, WatheBlocks.ANTHRACITE_STEEL_DOOR, WatheBlocks.Family.SMOOTH_ANTHRACITE_STEEL);
        this.registerFancySteel(generator, WatheBlocks.KHAKI_STEEL, WatheBlocks.SMOOTH_KHAKI_STEEL, WatheBlocks.KHAKI_STEEL_TILES, WatheBlocks.KHAKI_STEEL_PANEL, WatheBlocks.KHAKI_STEEL_TILES_PANEL, WatheBlocks.SMOOTH_KHAKI_STEEL_PANEL, WatheBlocks.KHAKI_STEEL_DOOR, WatheBlocks.Family.SMOOTH_KHAKI_STEEL);
        this.registerFancySteel(generator, WatheBlocks.MAROON_STEEL, WatheBlocks.SMOOTH_MAROON_STEEL, WatheBlocks.MAROON_STEEL_TILES, WatheBlocks.MAROON_STEEL_PANEL, WatheBlocks.MAROON_STEEL_TILES_PANEL, WatheBlocks.SMOOTH_MAROON_STEEL_PANEL, WatheBlocks.MAROON_STEEL_DOOR, WatheBlocks.Family.SMOOTH_MAROON_STEEL);
        this.registerFancySteel(generator, WatheBlocks.MUNTZ_STEEL, WatheBlocks.SMOOTH_MUNTZ_STEEL, WatheBlocks.MUNTZ_STEEL_TILES, WatheBlocks.MUNTZ_STEEL_PANEL, WatheBlocks.MUNTZ_STEEL_TILES_PANEL, WatheBlocks.SMOOTH_MUNTZ_STEEL_PANEL, WatheBlocks.MUNTZ_STEEL_DOOR, WatheBlocks.Family.SMOOTH_MUNTZ_STEEL);
        this.registerFancySteel(generator, WatheBlocks.NAVY_STEEL, WatheBlocks.SMOOTH_NAVY_STEEL, WatheBlocks.NAVY_STEEL_TILES, WatheBlocks.NAVY_STEEL_PANEL, WatheBlocks.NAVY_STEEL_TILES_PANEL, WatheBlocks.SMOOTH_NAVY_STEEL_PANEL, WatheBlocks.NAVY_STEEL_DOOR, WatheBlocks.Family.SMOOTH_NAVY_STEEL);
        this.registerParticleBlockWithItemSprite(generator, WatheBlocks.WHEEL, WatheBlocks.DARK_STEEL);
        this.registerParticleBlockWithItemSprite(generator, WatheBlocks.RUSTED_WHEEL, WatheBlocks.DARK_STEEL);
        generator.method_25641(WatheBlocks.RED_MOQUETTE);
        generator.method_25641(WatheBlocks.BROWN_MOQUETTE);
        generator.method_25641(WatheBlocks.BLUE_MOQUETTE);
        generator.method_25681(WatheBlocks.FOOD_PLATTER);
        generator.method_25708(WatheBlocks.DRINK_TRAY);
        this.registerPanel(generator, WatheBlocks.BARRIER_PANEL, class_4944.method_25860((class_2248)WatheBlocks.BARRIER_PANEL));
        generator.method_25542(WatheBlocks.LIGHT_BARRIER, WatheBlocks.LIGHT_BARRIER.method_8389());
        generator.method_25537(WatheBlocks.LIGHT_BARRIER.method_8389());
        generator.method_25708(WatheBlocks.HORN);
        generator.method_25537(WatheBlocks.CHIMNEY.method_8389());
    }

    private void registerFancySteel(class_4910 generator, class_2248 block, class_2248 smooth, class_2248 tiles, class_2248 panel, class_2248 tilesPanel, class_2248 smoothPanel, class_2248 door, class_5794 family) {
        generator.method_25641(block);
        this.registerPanel(generator, panel, block);
        generator.method_25641(tiles);
        this.registerPanel(generator, tilesPanel, tiles);
        this.registerFamily(generator, family);
        this.registerPanel(generator, smoothPanel, smooth);
        this.registerParticleBlockWithItemSprite(generator, door, block);
    }

    private static class_4942 item(String parent, class_4945 ... requiredTextureKeys) {
        return new class_4942(Optional.of(Wathe.id("item/" + parent)), Optional.empty(), requiredTextureKeys);
    }

    private static class_4942 model(String parent, @Nullable String variant, class_4945 ... keys) {
        return new class_4942(Optional.of(Wathe.id(parent)), Optional.ofNullable(variant), keys);
    }

    public void generateItemModels(class_4915 generator) {
        generator.method_25733(WatheItems.POISON_VIAL, SMALL_ITEM);
        generator.method_25733(WatheItems.SCORPION, SMALL_ITEM);
        generator.method_25733(WatheItems.OLD_FASHIONED, SMALL_ITEM);
        generator.method_25733(WatheItems.MOJITO, SMALL_ITEM);
        generator.method_25733(WatheItems.MARTINI, SMALL_ITEM);
        generator.method_25733(WatheItems.COSMOPOLITAN, SMALL_ITEM);
        generator.method_25733(WatheItems.CHAMPAGNE, SMALL_ITEM);
        generator.method_25733(WatheItems.GRENADE, SMALL_ITEM);
        generator.method_25733(WatheItems.THROWN_GRENADE, SMALL_ITEM);
        generator.method_25733(WatheItems.FIRECRACKER, SMALL_ITEM);
        for (KnifeItem.Skin value : KnifeItem.Skin.values()) {
            this.registerTemplateWeapon(KNIFE_TEMPLATE, value == KnifeItem.Skin.DEFAULT ? null : value.getName(), WatheItems.KNIFE, generator);
        }
    }

    private void registerBuiltinModel(class_1792 item, class_4915 generator) {
        generator.field_22844.accept(class_4941.method_25840((class_1792)item), new class_4940(class_2960.method_60654((String)"builtin/entity")));
    }

    private void registerTemplateWeapon(class_4942 templateModel, @Nullable String name, class_1792 item, class_4915 generator) {
        this.registerTemplateWeaponHandheld(templateModel, name, item, generator);
        this.registerTemplateWeaponInventory(templateModel, name, item, generator);
    }

    private void registerTemplateWeaponHandheld(class_4942 templateModel, @Nullable String name, class_1792 item, class_4915 generator) {
        this.registerTemplateWeaponHandheld(templateModel, name, class_7923.field_41178.method_10221((Object)item), generator);
    }

    private void registerTemplateWeaponHandheld(class_4942 templateModel, @Nullable String name, class_2960 itemId, class_4915 generator) {
        class_2960 handheldModelName = name == null ? WatheModelGen.getItemSubId(itemId, "_in_hand") : WatheModelGen.getItemSubId(itemId, "_" + name + "_in_hand");
        class_2960 handheldTexture = name == null ? WatheModelGen.getItemId(itemId) : WatheModelGen.getItemSubId(itemId, "_" + name);
        templateModel.method_25852(handheldModelName, class_4944.method_25895((class_2960)handheldTexture), generator.field_22844);
    }

    private void registerTemplateWeaponInventory(class_4942 templateModel, @Nullable String name, class_1792 item, class_4915 generator) {
        this.registerTemplateWeaponInventory(templateModel, name, class_7923.field_41178.method_10221((Object)item), generator);
    }

    private void registerTemplateWeaponInventory(class_4942 templateModel, @Nullable String name, class_2960 itemId, class_4915 generator) {
        class_2960 inventoryTexture = name == null ? WatheModelGen.getItemSubId(itemId, "") : WatheModelGen.getItemSubId(itemId, "_" + name);
        this.registerTemplateWeaponInventory(templateModel, name, itemId, inventoryTexture, generator);
    }

    private void registerTemplateWeaponInventory(class_4942 templateModel, @Nullable String name, class_2960 itemModelId, class_2960 inventoryTexture, class_4915 generator) {
        class_2960 inventoryModelName = name == null ? WatheModelGen.getItemSubId(itemModelId, "") : WatheModelGen.getItemSubId(itemModelId, "_" + name);
        KNIFE_TEMPLATE.method_25852(inventoryModelName, class_4944.method_25895((class_2960)inventoryTexture), generator.field_22844);
    }

    public static class_2960 getItemId(class_2960 itemId) {
        return itemId.method_45138("item/");
    }

    public static class_2960 getItemSubId(class_2960 itemId, String suffix) {
        return itemId.method_45134(path -> "item/" + path + suffix);
    }

    private class_4935 variant() {
        return class_4935.method_25824();
    }

    private <T> class_4935 variant(class_4938<T> variantSetting, T value) {
        return this.variant().method_25828(variantSetting, value);
    }

    private <T> class_4935 variant(class_2960 model, class_4938<T> variantSetting, T value) {
        return this.model(model).method_25828(variantSetting, value);
    }

    private class_4935 model(class_2960 model) {
        return this.variant(class_4936.field_22887, model);
    }

    private void registerBranch(class_4910 generator, class_2248 branch, class_2248 log) {
        this.registerBranch(generator, branch, log, class_4944.method_25866((class_2248)branch, (String)"_top"));
    }

    private void registerPole(class_4910 generator, class_2248 pole, class_2248 block) {
        this.registerBranch(generator, pole, block, class_4944.method_25866((class_2248)block, (String)"_top"));
    }

    private void registerBranch(class_4910 generator, class_2248 branch, class_2248 log, class_2960 topTexture) {
        class_4944 faceMap = new class_4944().method_25868(class_4945.field_23018, class_4944.method_25860((class_2248)log));
        class_4944 map = faceMap.method_25879(class_4945.field_23015, topTexture);
        class_2960 face = BRANCH_FACE.method_25846(branch, faceMap, generator.field_22831);
        class_2960 faceHorizontal = BRANCH_FACE_HORIZONTAL.method_25846(branch, faceMap, generator.field_22831);
        class_2960 front = BRANCH_FRONT.method_25846(branch, map, generator.field_22831);
        class_2960 back = BRANCH_BACK.method_25846(branch, map, generator.field_22831);
        class_2960 inventory = BRANCH_INVENTORY.method_25846(branch, map, generator.field_22831);
        generator.method_25623(branch, inventory);
        class_4922 blockStateSupplier = class_4922.method_25758((class_2248)branch);
        for (class_2350 side : class_2350.values()) {
            this.addBranchSide(blockStateSupplier, side, face, faceHorizontal, front, back);
        }
        generator.field_22830.accept(blockStateSupplier);
    }

    private class_4935 rotateBranchSide(class_4935 variant, class_2350 side) {
        return switch (side.method_10166()) {
            default -> throw new MatchException(null, null);
            case class_2350.class_2351.field_11048 -> variant.method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891);
            case class_2350.class_2351.field_11052 -> variant.method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22893);
            case class_2350.class_2351.field_11051 -> variant;
        };
    }

    private void addBranchSide(class_4922 blockStateSupplier, class_2350 side, class_2960 face, class_2960 faceHorizontal, class_2960 front, class_2960 back) {
        class_2746 sideProperty = (class_2746)BranchBlock.field_11329.get(side);
        class_2746 horizontalProperty1 = (class_2746)BranchBlock.field_11329.get(side.method_10166().method_10178() ? class_2350.field_11034 : side.method_10170());
        class_2746 horizontalProperty2 = (class_2746)BranchBlock.field_11329.get(side.method_10166().method_10178() ? class_2350.field_11039 : side.method_10160());
        boolean isFront = side.method_10171() == (side.method_10166().equals((Object)class_2350.class_2351.field_11051) ? class_2350.class_2352.field_11060 : class_2350.class_2352.field_11056);
        blockStateSupplier.method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)sideProperty, (Comparable)Boolean.valueOf(true)), this.rotateBranchSide(class_4935.method_25824().method_25828(class_4936.field_22887, (Object)(isFront ? front : back)), side)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)sideProperty, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)horizontalProperty1, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)horizontalProperty2, (Comparable)Boolean.valueOf(false)), this.rotateForFace(class_4935.method_25824().method_25828(class_4936.field_22887, (Object)face), side, false)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)sideProperty, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)horizontalProperty1, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)horizontalProperty2, (Comparable)Boolean.valueOf(false)), this.rotateForFace(class_4935.method_25824().method_25828(class_4936.field_22887, (Object)face), side, false)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)sideProperty, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)horizontalProperty1, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)horizontalProperty2, (Comparable)Boolean.valueOf(true)), this.rotateForFace(class_4935.method_25824().method_25828(class_4936.field_22887, (Object)face), side, false)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)sideProperty, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)horizontalProperty1, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)horizontalProperty2, (Comparable)Boolean.valueOf(true)), this.rotateForFace(class_4935.method_25824().method_25828(class_4936.field_22887, (Object)faceHorizontal), side, false));
    }

    private class_4935 rotateForFace(class_4935 variant, class_2350 direction, boolean uvlock) {
        if (uvlock) {
            variant.method_25828(class_4936.field_22888, (Object)true);
        }
        switch (direction) {
            case field_11034: {
                variant.method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891);
                break;
            }
            case field_11035: {
                variant.method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892);
                break;
            }
            case field_11039: {
                variant.method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893);
                break;
            }
            case field_11036: {
                variant.method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22893);
                break;
            }
            case field_11033: {
                variant.method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891);
            }
        }
        return variant;
    }

    private class_4935 rotateForFace(class_4935 variant, class_2350 direction) {
        return this.rotateForFace(variant, direction, false);
    }

    private void registerVentShaft(class_4910 generator, class_2248 block) {
        class_4944 openingTexture = new class_4944().method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)block, (String)"_opening"));
        class_4944 sideTexture = new class_4944().method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)block, (String)"_side")).method_25868(class_4945.field_27791, class_4944.method_25866((class_2248)block, (String)"_inside"));
        class_4944 junctionTexture = new class_4944().method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)block, (String)"_junction")).method_25868(class_4945.field_27791, class_4944.method_25866((class_2248)block, (String)"_junction_inside"));
        class_4944 inventoryTexture = new class_4944().method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)block, (String)"_side")).method_25868(class_4945.field_27791, class_4944.method_25866((class_2248)block, (String)"_inside")).method_25868(class_4945.field_23013, class_4944.method_25866((class_2248)block, (String)"_opening"));
        class_2960 openingModel = VENT_SHAFT_SIDE_OPENING.method_25846(block, openingTexture, generator.field_22831);
        class_2960 sideModel = VENT_SHAFT_SIDE.method_25847(block, "_side", sideTexture, generator.field_22831);
        class_2960 verticalModel = VENT_SHAFT_SIDE_VERTICAL.method_25846(block, sideTexture, generator.field_22831);
        class_2960 junctionModel = VENT_SHAFT_SIDE.method_25847(block, "_junction", junctionTexture, generator.field_22831);
        class_2960 inventoryModel = VENT_SHAFT_INVENTORY.method_25846(block, inventoryTexture, generator.field_22831);
        generator.method_25623(block, inventoryModel);
        class_4922 blockStateSupplier = class_4922.method_25758((class_2248)block);
        for (class_2350 direction : class_2350.values()) {
            class_2350 leftDirection;
            boolean horizontalAxis = direction.method_10166().method_10179();
            boolean isUp = direction == class_2350.field_11036;
            class_2350 class_23502 = leftDirection = horizontalAxis ? direction.method_10170() : class_2350.field_11034;
            class_2350 topDirection = horizontalAxis ? class_2350.field_11036 : (isUp ? class_2350.field_11035 : class_2350.field_11043);
            class_2746 property = (class_2746)class_2429.field_11329.get(direction);
            class_2746 left = (class_2746)class_2429.field_11329.get(leftDirection);
            class_2746 right = (class_2746)class_2429.field_11329.get(leftDirection.method_10153());
            class_2746 top = (class_2746)class_2429.field_11329.get(topDirection);
            class_2746 bottom = (class_2746)class_2429.field_11329.get(topDirection.method_10153());
            class_4918.class_4921 whenSide = class_4918.method_25744().method_25751((class_2769)property, (Comparable)Boolean.valueOf(true));
            class_4918 whenVertical = class_4918.method_35870((class_4918[])new class_4918[]{class_4918.method_25744().method_25751((class_2769)top, (Comparable)Boolean.valueOf(false)), class_4918.method_25744().method_25751((class_2769)bottom, (Comparable)Boolean.valueOf(false))});
            class_4918 whenNotVertical = class_4918.method_35870((class_4918[])new class_4918[]{class_4918.method_25744().method_25751((class_2769)top, (Comparable)Boolean.valueOf(true)), class_4918.method_25744().method_25751((class_2769)bottom, (Comparable)Boolean.valueOf(true))});
            class_4918 whenHorizontal = class_4918.method_35870((class_4918[])new class_4918[]{class_4918.method_25744().method_25751((class_2769)left, (Comparable)Boolean.valueOf(false)), class_4918.method_25744().method_25751((class_2769)right, (Comparable)Boolean.valueOf(false))});
            class_4918 whenNotHorizontal = class_4918.method_35870((class_4918[])new class_4918[]{class_4918.method_25744().method_25751((class_2769)left, (Comparable)Boolean.valueOf(true)), class_4918.method_25744().method_25751((class_2769)right, (Comparable)Boolean.valueOf(true))});
            this.addVentSide(blockStateSupplier, direction, openingModel, (class_4918)class_4918.method_25744().method_25751((class_2769)property, (Comparable)Boolean.valueOf(false)));
            this.addVentSide(blockStateSupplier, direction, sideModel, class_4918.method_35870((class_4918[])new class_4918[]{whenSide, whenHorizontal, whenNotVertical}));
            this.addVentSide(blockStateSupplier, direction, verticalModel, class_4918.method_35870((class_4918[])new class_4918[]{whenSide, whenVertical, whenNotHorizontal}));
            this.addVentSide(blockStateSupplier, direction, junctionModel, class_4918.method_35870((class_4918[])new class_4918[]{whenSide, class_4918.method_25746((class_4918[])new class_4918[]{class_4918.method_25744().method_25751((class_2769)top, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)bottom, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)left, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)right, (Comparable)Boolean.valueOf(false)), class_4918.method_25744().method_25751((class_2769)top, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)bottom, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)left, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)right, (Comparable)Boolean.valueOf(false)), class_4918.method_25744().method_25751((class_2769)top, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)bottom, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)left, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)right, (Comparable)Boolean.valueOf(false)), class_4918.method_25744().method_25751((class_2769)top, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)bottom, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)left, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)right, (Comparable)Boolean.valueOf(true)), class_4918.method_25744().method_25751((class_2769)top, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)bottom, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)left, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)right, (Comparable)Boolean.valueOf(false)), class_4918.method_35870((class_4918[])new class_4918[]{class_4918.method_25746((class_4918[])new class_4918[]{class_4918.method_25744().method_25751((class_2769)top, (Comparable)Boolean.valueOf(true)), class_4918.method_25744().method_25751((class_2769)bottom, (Comparable)Boolean.valueOf(true))}), class_4918.method_25746((class_4918[])new class_4918[]{class_4918.method_25744().method_25751((class_2769)left, (Comparable)Boolean.valueOf(true)), class_4918.method_25744().method_25751((class_2769)right, (Comparable)Boolean.valueOf(true))})})})}));
        }
        generator.field_22830.accept(blockStateSupplier);
    }

    private void addVentSide(class_4922 blockStateSupplier, class_2350 direction, class_2960 model, class_4918 when) {
        blockStateSupplier.method_25760(when, this.rotateForFace(class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model), direction, false));
    }

    private void registerItemParticleBlock(class_4910 generator, class_2248 block) {
        class_2960 model = class_4943.field_22908.method_25852(class_4941.method_25842((class_2248)block), class_4944.method_25862((class_1792)block.method_8389()), generator.field_22831);
        generator.field_22830.accept(class_4910.method_25644((class_2248)block, (class_2960)model));
    }

    private void registerParticleBlockWithItemSprite(class_4910 generator, class_2248 block, class_2248 particleBlock) {
        class_4943.field_22938.method_25852(class_4941.method_25840((class_1792)block.method_8389()), class_4944.method_25871((class_1792)block.method_8389()), generator.field_22831);
        this.registerParticleBlock(generator, block, particleBlock);
    }

    private void registerParticleBlock(class_4910 generator, class_2248 block, class_2248 particleBlock) {
        class_2960 model = class_4943.field_22908.method_25852(class_4941.method_25842((class_2248)block), class_4944.method_25901((class_2248)particleBlock), generator.field_22831);
        generator.field_22830.accept(class_4910.method_25644((class_2248)block, (class_2960)model));
    }

    private void registerFamily(class_4910 generator, class_5794 family) {
        class_4946 texturedModel = this.uniqueModels.getOrDefault(family.method_33469(), class_4946.field_23036.get(family.method_33469()));
        class_4910 class_49102 = generator;
        Objects.requireNonNull(class_49102);
        new class_4910.class_4912(class_49102, texturedModel.method_25921()).method_25718(family.method_33469(), texturedModel.method_25914()).method_33522(family);
    }

    private void registerWalkway(class_4910 generator, class_2248 block) {
        class_4944 textureMap = new class_4944().method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)block, (String)"_side")).method_25868(class_4945.field_23015, class_4944.method_25860((class_2248)block));
        class_2960 top = WALKWAY_TOP.method_25847(block, "_top", textureMap, generator.field_22831);
        class_2960 bottom = WALKWAY_BOTTOM.method_25847(block, "_bottom", textureMap, generator.field_22831);
        generator.method_25623(block, bottom);
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775((class_4926)class_4926.method_25783(WalkwayBlock.HALF).method_25793((Comparable)class_2760.field_12619, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)top)).method_25793((Comparable)class_2760.field_12617, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)bottom))));
    }

    private void registerCouch(class_4910 generator, class_2248 block, class_4942 left, class_4942 right, class_4942 single, class_4942 noArms) {
        class_4944 textureMap = new class_4944().method_25868(class_4945.field_23011, class_4944.method_25860((class_2248)block));
        class_2960 leftModel = left.method_25846(block, textureMap, generator.field_22831);
        class_2960 rightModel = right.method_25846(block, textureMap, generator.field_22831);
        class_2960 singleModel = single.method_25846(block, textureMap, generator.field_22831);
        class_2960 noArmsModel = noArms.method_25846(block, textureMap, generator.field_22831);
        generator.method_25623(block, singleModel);
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775((class_4926)class_4926.method_25783(CouchBlock.ARMS).method_25793((Comparable)((Object)CouchArms.LEFT), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)leftModel)).method_25793((Comparable)((Object)CouchArms.RIGHT), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)rightModel)).method_25793((Comparable)((Object)CouchArms.SINGLE), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)singleModel)).method_25793((Comparable)((Object)CouchArms.NO_ARMS), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)noArmsModel))).method_25775(class_4910.method_25599()));
    }

    private void registerLoungeCouch(class_4910 generator, class_2248 block) {
        this.registerCouch(generator, block, LOUNGE_COUCH_LEFT, LOUNGE_COUCH_RIGHT, LOUNGE_COUCH_SINGLE, LOUNGE_COUCH_NO_ARMS);
    }

    private void registerLeatherCouch(class_4910 generator, class_2248 block) {
        this.registerCouch(generator, block, LEATHER_COUCH_LEFT, LEATHER_COUCH_RIGHT, LEATHER_COUCH, LEATHER_COUCH_MIDDLE);
    }

    private void registerTrimmedStairs(class_4910 generator, class_2248 block) {
        class_4944 supportTexture = class_4944.method_25869((class_2960)class_4941.method_25843((class_2248)block, (String)"_support"));
        class_4944 singleTexture = class_4944.method_25869((class_2960)class_4941.method_25843((class_2248)block, (String)"_single"));
        class_4944 leftTexture = class_4944.method_25869((class_2960)class_4941.method_25843((class_2248)block, (String)"_left"));
        class_4944 rightTexture = class_4944.method_25869((class_2960)class_4941.method_25843((class_2248)block, (String)"_right"));
        class_4944 middleTexture = class_4944.method_25869((class_2960)class_4941.method_25843((class_2248)block, (String)"_middle"));
        class_2960 support = TRIMMED_STAIR_SUPPORT.method_25846(block, supportTexture, generator.field_22831);
        class_2960 single = TRIMMED_STAIRS.method_25847(block, "_single", singleTexture, generator.field_22831);
        class_2960 left = TRIMMED_STAIRS.method_25847(block, "_left", leftTexture, generator.field_22831);
        class_2960 right = TRIMMED_STAIRS.method_25847(block, "_right", rightTexture, generator.field_22831);
        class_2960 middle = TRIMMED_STAIRS.method_25847(block, "_middle", middleTexture, generator.field_22831);
        class_4922 blockStateSupplier = class_4922.method_25758((class_2248)block);
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            blockStateSupplier.method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)TrimmedStairsBlock.field_11177, (Comparable)direction).method_25751((class_2769)TrimmedStairsBlock.LEFT, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)TrimmedStairsBlock.RIGHT, (Comparable)Boolean.valueOf(false)), this.rotateForFace(this.model(middle), direction));
            blockStateSupplier.method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)TrimmedStairsBlock.field_11177, (Comparable)direction).method_25751((class_2769)TrimmedStairsBlock.LEFT, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)TrimmedStairsBlock.RIGHT, (Comparable)Boolean.valueOf(false)), this.rotateForFace(this.model(left), direction));
            blockStateSupplier.method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)TrimmedStairsBlock.field_11177, (Comparable)direction).method_25751((class_2769)TrimmedStairsBlock.LEFT, (Comparable)Boolean.valueOf(false)).method_25751((class_2769)TrimmedStairsBlock.RIGHT, (Comparable)Boolean.valueOf(true)), this.rotateForFace(this.model(right), direction));
            blockStateSupplier.method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)TrimmedStairsBlock.field_11177, (Comparable)direction).method_25751((class_2769)TrimmedStairsBlock.LEFT, (Comparable)Boolean.valueOf(true)).method_25751((class_2769)TrimmedStairsBlock.RIGHT, (Comparable)Boolean.valueOf(true)), this.rotateForFace(this.model(single), direction));
            blockStateSupplier.method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)TrimmedStairsBlock.field_11177, (Comparable)direction).method_25751((class_2769)TrimmedStairsBlock.SUPPORT, (Comparable)Boolean.valueOf(true)), this.rotateForFace(this.model(support), direction));
        }
        generator.method_25623(block, single);
        generator.field_22830.accept(blockStateSupplier);
    }

    private void registerLiquid(class_4910 generator, class_1792 item, class_2960 texture) {
        class_4943.field_22911.method_25852(class_4941.method_25840((class_1792)item), class_4944.method_25875((class_2960)texture), generator.field_22831);
    }

    private void registerColumn(class_4910 generator, class_2248 block) {
        class_4944 textureMap = class_4944.method_25894((class_2248)block);
        class_2960 model = class_4943.field_22974.method_25846(block, textureMap, generator.field_22831);
        generator.field_22830.accept(class_4910.method_25644((class_2248)block, (class_2960)model));
    }

    private void registerVariedBookshelf(class_4910 generator, class_2248 block, class_2248 planks) {
        class_4944 textureMap = new class_4944().method_25868(class_4945.field_23013, class_4944.method_25860((class_2248)planks)).method_25868(class_4945.field_23018, class_4944.method_25860((class_2248)block));
        class_4944 altTextureMap = new class_4944().method_25868(class_4945.field_23013, class_4944.method_25860((class_2248)planks)).method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)block, (String)"_alt"));
        class_2960 model = class_4943.field_22974.method_25846(block, textureMap, generator.field_22831);
        class_2960 altModel = class_4943.field_22974.method_25847(block, "_alt", altTextureMap, generator.field_22831);
        List<class_2960> models = List.of(model, altModel);
        generator.method_25623(block, model);
        generator.field_22830.accept(class_4925.method_25771((class_2248)block, (class_4935[])((class_4935[])class_4910.method_25583(models, variant -> variant).toArray(class_4935[]::new))));
    }

    private void registerCabinet(class_4910 generator, class_2248 block) {
        class_2960 sideTexture = class_4944.method_25866((class_2248)block, (String)"_side");
        class_4944 closedTexture = new class_4944().method_25868(class_4945.field_23018, sideTexture).method_25868(class_4945.field_23015, sideTexture).method_25868(class_4945.field_23016, class_4944.method_25866((class_2248)block, (String)"_front"));
        class_4944 openTexture = new class_4944().method_25868(class_4945.field_23018, sideTexture).method_25868(SHELF_KEY, class_4944.method_25866((class_2248)block, (String)"_front_open_shelf")).method_25868(class_4945.field_23027, class_4944.method_25866((class_2248)block, (String)"_wall")).method_25868(class_4945.field_23016, class_4944.method_25866((class_2248)block, (String)"_front_open"));
        class_2960 closedModel = class_4943.field_22978.method_25846(block, closedTexture, generator.field_22831);
        class_2960 openModel = CABINET_OPEN.method_25846(block, openTexture, generator.field_22831);
        generator.method_25623(block, closedModel);
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775(class_4910.method_25565((class_2746)CabinetBlock.OPEN, (class_2960)openModel, (class_2960)closedModel)).method_25775(class_4910.method_25599()));
    }

    private void registerPanel(class_4910 generator, class_2248 block, class_2248 textureBlock) {
        this.registerPanel(generator, block, class_4944.method_25860((class_2248)textureBlock));
    }

    private void registerPanel(class_4910 generator, class_2248 block, class_2960 texture) {
        class_4943.field_22938.method_25852(class_4941.method_25840((class_1792)block.method_8389()), class_4944.method_25895((class_2960)texture), generator.field_22831);
        class_2960 model = PANEL.method_25846(block, class_4944.method_25875((class_2960)texture), generator.field_22831);
        class_4922 blockStateSupplier = class_4922.method_25758((class_2248)block);
        class_4918.class_4921 propertyCondition = class_4918.method_25744();
        class_4910.field_28548.stream().map(Pair::getFirst).forEach(property -> propertyCondition.method_25751((class_2769)property, (Comparable)Boolean.valueOf(false)));
        for (Pair pair : class_4910.field_28548) {
            class_2746 facingProperty = (class_2746)pair.getFirst();
            class_4935 variant = (class_4935)((Function)pair.getSecond()).apply(model);
            blockStateSupplier.method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)facingProperty, (Comparable)Boolean.valueOf(true)), variant);
            blockStateSupplier.method_25760((class_4918)propertyCondition, variant);
        }
        generator.field_22830.accept(blockStateSupplier);
    }

    private class_4935 rotateForAxis(class_4935 variant, class_2350.class_2351 axis) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case class_2350.class_2351.field_11048 -> variant.method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893);
            case class_2350.class_2351.field_11052 -> variant.method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891);
            case class_2350.class_2351.field_11051 -> variant;
        };
    }

    private void registerBar(class_4910 generator, class_2248 block) {
        class_4944 textureMap = class_4944.method_25872((class_2248)block);
        class_2960 model = BAR.method_25846(block, textureMap, generator.field_22831);
        class_2960 topModel = BAR_TOP.method_25846(block, textureMap, generator.field_22831);
        class_2960 bottomModel = BAR_BOTTOM.method_25846(block, textureMap, generator.field_22831);
        generator.method_25537(block.method_8389());
        class_4922 blockStateSupplier = class_4922.method_25758((class_2248)block);
        for (class_2350.class_2351 axis : class_2350.class_2351.values()) {
            blockStateSupplier.method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)BarBlock.field_11459, (Comparable)axis), this.rotateForAxis(this.model(model), axis)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)BarBlock.field_11459, (Comparable)axis).method_25751((class_2769)BarBlock.TOP, (Comparable)Boolean.valueOf(true)), this.rotateForAxis(this.model(topModel), axis)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)BarBlock.field_11459, (Comparable)axis).method_25751((class_2769)BarBlock.BOTTOM, (Comparable)Boolean.valueOf(true)), this.rotateForAxis(this.model(bottomModel), axis));
        }
        generator.field_22830.accept(blockStateSupplier);
    }

    private void registerLedge(class_4910 generator, class_2248 block, class_2248 barBlock) {
        class_4944 textureMap = class_4944.method_25872((class_2248)barBlock);
        class_2960 model = LEDGE.method_25846(block, textureMap, generator.field_22831);
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775((class_4926)class_4926.method_25783((class_2769)LedgeBlock.field_11177).method_25793((Comparable)class_2350.field_11043, this.model(model)).method_25793((Comparable)class_2350.field_11034, this.model(model).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25793((Comparable)class_2350.field_11035, this.model(model).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25793((Comparable)class_2350.field_11039, this.model(model).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893))));
        generator.method_25537(block.method_8389());
    }

    private void registerLadder(class_4910 generator, class_2248 block) {
        class_4944 textureMap = class_4944.method_25872((class_2248)block).method_25868(class_4945.field_23012, class_4944.method_25860((class_2248)block));
        LADDER.method_25846(block, textureMap, generator.field_22831);
        generator.method_25600(block);
        generator.method_25708(block);
    }

    private void registerTrimmedLantern(class_4910 generator, class_2248 block, boolean hasEmergencyVariant) {
        class_4944 litTexture = new class_4944().method_25868(class_4945.field_23015, class_4944.method_25866((class_2248)block, (String)"_top")).method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)block, (String)"_side_lit")).method_25868(class_4945.field_23014, class_4944.method_25866((class_2248)block, (String)"_bottom_lit"));
        class_4944 unlitTexture = new class_4944().method_25868(class_4945.field_23015, class_4944.method_25866((class_2248)block, (String)"_top")).method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)block, (String)"_side_unlit")).method_25868(class_4945.field_23014, class_4944.method_25866((class_2248)block, (String)"_bottom_unlit"));
        class_2960 litCeiling = TRIMMED_LANTERN_CEILING.method_25847(block, "_ceiling_lit", litTexture, generator.field_22831);
        class_2960 litWall = TRIMMED_LANTERN_WALL.method_25847(block, "_wall_lit", litTexture, generator.field_22831);
        class_2960 litFloor = TRIMMED_LANTERN_FLOOR.method_25847(block, "_floor_lit", litTexture, generator.field_22831);
        class_2960 unlitCeiling = TRIMMED_LANTERN_CEILING.method_25847(block, "_ceiling_unlit", unlitTexture, generator.field_22831);
        class_2960 unlitWall = TRIMMED_LANTERN_WALL.method_25847(block, "_wall_unlit", unlitTexture, generator.field_22831);
        class_2960 unlitFloor = TRIMMED_LANTERN_FLOOR.method_25847(block, "_floor_unlit", unlitTexture, generator.field_22831);
        class_4944 unpoweredTexture = new class_4944().method_25868(class_4945.field_23015, class_4944.method_25866((class_2248)block, (String)"_top")).method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)block, (String)"_side_emergency")).method_25868(class_4945.field_23014, class_4944.method_25866((class_2248)block, (String)"_bottom_emergency"));
        class_2960 unpoweredCeiling = hasEmergencyVariant ? TRIMMED_LANTERN_CEILING.method_25847(block, "_ceiling_emergency", unpoweredTexture, generator.field_22831) : unlitCeiling;
        class_2960 unpoweredWall = hasEmergencyVariant ? TRIMMED_LANTERN_WALL.method_25847(block, "_wall_emergency", unpoweredTexture, generator.field_22831) : unlitWall;
        class_2960 unpoweredFloor = hasEmergencyVariant ? TRIMMED_LANTERN_FLOOR.method_25847(block, "_floor_emergency", unpoweredTexture, generator.field_22831) : unlitFloor;
        generator.method_25623(block, unlitFloor);
        class_4925 blockStateSupplier = class_4925.method_25769((class_2248)block);
        blockStateSupplier.method_25775((class_4926)class_4926.method_25785((class_2769)TrimmedLanternBlock.field_10927, (class_2769)TrimmedLanternBlock.ACTIVE, (class_2769)TrimmedLanternBlock.LIT).method_25806((Comparable)class_2350.field_11043, (Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(false), this.model(unlitWall)).method_25806((Comparable)class_2350.field_11034, (Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(false), this.rotateForFace(this.model(unlitWall), class_2350.field_11034, false)).method_25806((Comparable)class_2350.field_11035, (Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(false), this.rotateForFace(this.model(unlitWall), class_2350.field_11035, false)).method_25806((Comparable)class_2350.field_11039, (Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(false), this.rotateForFace(this.model(unlitWall), class_2350.field_11039, false)).method_25806((Comparable)class_2350.field_11036, (Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(false), this.model(unlitFloor)).method_25806((Comparable)class_2350.field_11033, (Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(false), this.model(unlitCeiling)).method_25806((Comparable)class_2350.field_11043, (Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(true), this.model(litWall)).method_25806((Comparable)class_2350.field_11034, (Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(true), this.rotateForFace(this.model(litWall), class_2350.field_11034, false)).method_25806((Comparable)class_2350.field_11035, (Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(true), this.rotateForFace(this.model(litWall), class_2350.field_11035, false)).method_25806((Comparable)class_2350.field_11039, (Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(true), this.rotateForFace(this.model(litWall), class_2350.field_11039, false)).method_25806((Comparable)class_2350.field_11036, (Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(true), this.model(litFloor)).method_25806((Comparable)class_2350.field_11033, (Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(true), this.model(litCeiling)).method_25806((Comparable)class_2350.field_11043, (Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(false), this.model(unpoweredWall)).method_25806((Comparable)class_2350.field_11034, (Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(false), this.rotateForFace(this.model(unpoweredWall), class_2350.field_11034, false)).method_25806((Comparable)class_2350.field_11035, (Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(false), this.rotateForFace(this.model(unpoweredWall), class_2350.field_11035, false)).method_25806((Comparable)class_2350.field_11039, (Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(false), this.rotateForFace(this.model(unpoweredWall), class_2350.field_11039, false)).method_25806((Comparable)class_2350.field_11036, (Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(false), this.model(unpoweredFloor)).method_25806((Comparable)class_2350.field_11033, (Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(false), this.model(unpoweredCeiling)).method_25806((Comparable)class_2350.field_11043, (Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(true), this.model(unpoweredWall)).method_25806((Comparable)class_2350.field_11034, (Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(true), this.rotateForFace(this.model(unpoweredWall), class_2350.field_11034, false)).method_25806((Comparable)class_2350.field_11035, (Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(true), this.rotateForFace(this.model(unpoweredWall), class_2350.field_11035, false)).method_25806((Comparable)class_2350.field_11039, (Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(true), this.rotateForFace(this.model(unpoweredWall), class_2350.field_11039, false)).method_25806((Comparable)class_2350.field_11036, (Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(true), this.model(unpoweredFloor)).method_25806((Comparable)class_2350.field_11033, (Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(true), this.model(unpoweredCeiling)));
        generator.field_22830.accept(blockStateSupplier);
    }

    private class_4926 wallMountedVariantMap(class_2960 model) {
        return class_4926.method_25784((class_2769)class_2341.field_11177, (class_2769)class_2341.field_11007).method_25800((facing, face) -> {
            if (face == class_2738.field_12471) {
                return this.rotateForFace(this.model(model), (class_2350)facing, false);
            }
            return this.rotateForFace(this.rotateForFace(this.model(model), face == class_2738.field_12475 ? class_2350.field_11036 : class_2350.field_11033, false), facing.method_10153(), false);
        });
    }

    private class_4926 wallMountedVariantMap(class_2746 booleanProperty, class_2960 trueModel, class_2960 falseModel) {
        return class_4926.method_25785((class_2769)class_2341.field_11177, (class_2769)class_2341.field_11007, (class_2769)booleanProperty).method_25805((facing, face, bl) -> {
            class_2960 model;
            class_2960 class_29602 = model = bl != false ? trueModel : falseModel;
            if (face == class_2738.field_12471) {
                return this.rotateForFace(this.model(model), (class_2350)facing, false);
            }
            return this.rotateForFace(this.rotateForFace(this.model(model), face == class_2738.field_12475 ? class_2350.field_11036 : class_2350.field_11033, false), facing.method_10153(), false);
        });
    }

    private void registerSprinkler(class_4910 generator, class_2248 block, class_2248 particleBlock) {
        class_2960 model = SPRINKLER.method_25846(block, class_4944.method_25872((class_2248)block).method_25868(class_4945.field_23012, class_4944.method_25860((class_2248)particleBlock)), generator.field_22831);
        generator.method_25623(block, model);
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775(this.wallMountedVariantMap(model)));
    }

    private void registerWallLamp(class_4910 generator, class_2248 block, boolean hasEmergencyVariant) {
        class_4944 litTexture = class_4944.method_25869((class_2960)class_4944.method_25866((class_2248)block, (String)"_lit"));
        class_4944 unlitTexture = class_4944.method_25869((class_2960)class_4944.method_25866((class_2248)block, (String)"_unlit"));
        class_2960 litCeiling = WALL_LAMP_CEILING.method_25847(block, "_ceiling_lit", litTexture, generator.field_22831);
        class_2960 litWall = WALL_LAMP_WALL.method_25847(block, "_wall_lit", litTexture, generator.field_22831);
        class_2960 litFloor = WALL_LAMP_FLOOR.method_25847(block, "_floor_lit", litTexture, generator.field_22831);
        class_2960 unlitCeiling = WALL_LAMP_CEILING.method_25847(block, "_ceiling_unlit", unlitTexture, generator.field_22831);
        class_2960 unlitWall = WALL_LAMP_WALL.method_25847(block, "_wall_unlit", unlitTexture, generator.field_22831);
        class_2960 unlitFloor = WALL_LAMP_FLOOR.method_25847(block, "_floor_unlit", unlitTexture, generator.field_22831);
        class_4944 unpoweredTexture = hasEmergencyVariant ? class_4944.method_25869((class_2960)class_4944.method_25866((class_2248)block, (String)"_emergency")) : unlitTexture;
        class_2960 unpoweredCeiling = hasEmergencyVariant ? WALL_LAMP_CEILING.method_25847(block, "_ceiling_emergency", unpoweredTexture, generator.field_22831) : unlitCeiling;
        class_2960 unpoweredWall = hasEmergencyVariant ? WALL_LAMP_WALL.method_25847(block, "_wall_emergency", unpoweredTexture, generator.field_22831) : unlitWall;
        class_2960 unpoweredFloor = hasEmergencyVariant ? WALL_LAMP_FLOOR.method_25847(block, "_floor_emergency", unpoweredTexture, generator.field_22831) : unlitFloor;
        generator.method_25623(block, unlitFloor);
        class_4925 blockStateSupplier = class_4925.method_25769((class_2248)block);
        blockStateSupplier.method_25775((class_4926)class_4926.method_25785((class_2769)WallLampBlock.field_10927, (class_2769)WallLampBlock.ACTIVE, (class_2769)WallLampBlock.LIT).method_25806((Comparable)class_2350.field_11043, (Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(false), this.model(unlitWall)).method_25806((Comparable)class_2350.field_11034, (Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(false), this.rotateForFace(this.model(unlitWall), class_2350.field_11034, false)).method_25806((Comparable)class_2350.field_11035, (Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(false), this.rotateForFace(this.model(unlitWall), class_2350.field_11035, false)).method_25806((Comparable)class_2350.field_11039, (Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(false), this.rotateForFace(this.model(unlitWall), class_2350.field_11039, false)).method_25806((Comparable)class_2350.field_11036, (Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(false), this.model(unlitFloor)).method_25806((Comparable)class_2350.field_11033, (Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(false), this.model(unlitCeiling)).method_25806((Comparable)class_2350.field_11043, (Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(true), this.model(litWall)).method_25806((Comparable)class_2350.field_11034, (Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(true), this.rotateForFace(this.model(litWall), class_2350.field_11034, false)).method_25806((Comparable)class_2350.field_11035, (Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(true), this.rotateForFace(this.model(litWall), class_2350.field_11035, false)).method_25806((Comparable)class_2350.field_11039, (Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(true), this.rotateForFace(this.model(litWall), class_2350.field_11039, false)).method_25806((Comparable)class_2350.field_11036, (Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(true), this.model(litFloor)).method_25806((Comparable)class_2350.field_11033, (Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(true), this.model(litCeiling)).method_25806((Comparable)class_2350.field_11043, (Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(false), this.model(unpoweredWall)).method_25806((Comparable)class_2350.field_11034, (Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(false), this.rotateForFace(this.model(unpoweredWall), class_2350.field_11034, false)).method_25806((Comparable)class_2350.field_11035, (Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(false), this.rotateForFace(this.model(unpoweredWall), class_2350.field_11035, false)).method_25806((Comparable)class_2350.field_11039, (Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(false), this.rotateForFace(this.model(unpoweredWall), class_2350.field_11039, false)).method_25806((Comparable)class_2350.field_11036, (Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(false), this.model(unpoweredFloor)).method_25806((Comparable)class_2350.field_11033, (Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(false), this.model(unpoweredCeiling)).method_25806((Comparable)class_2350.field_11043, (Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(true), this.model(unpoweredWall)).method_25806((Comparable)class_2350.field_11034, (Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(true), this.rotateForFace(this.model(unpoweredWall), class_2350.field_11034, false)).method_25806((Comparable)class_2350.field_11035, (Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(true), this.rotateForFace(this.model(unpoweredWall), class_2350.field_11035, false)).method_25806((Comparable)class_2350.field_11039, (Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(true), this.rotateForFace(this.model(unpoweredWall), class_2350.field_11039, false)).method_25806((Comparable)class_2350.field_11036, (Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(true), this.model(unpoweredFloor)).method_25806((Comparable)class_2350.field_11033, (Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(true), this.model(unpoweredCeiling)));
        generator.field_22830.accept(blockStateSupplier);
    }

    private void registerCargoBox(class_4910 generator, class_2248 block) {
        class_4944 closedTexture = new class_4944().method_25868(class_4945.field_23015, class_4944.method_25866((class_2248)block, (String)"_top")).method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)block, (String)"_side")).method_25868(class_4945.field_23014, class_4944.method_25866((class_2248)block, (String)"_bottom"));
        class_4944 openTexture = new class_4944().method_25868(class_4945.field_23015, class_4944.method_25866((class_2248)block, (String)"_top_open")).method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)block, (String)"_side")).method_25868(class_4945.field_23014, class_4944.method_25866((class_2248)block, (String)"_bottom"));
        class_2960 closedModel = CARGO_BOX.method_25846(block, closedTexture, generator.field_22831);
        class_2960 openModel = CARGO_BOX_OPEN.method_25846(block, openTexture, generator.field_22831);
        class_2960 inventoryModel = class_4943.field_22977.method_25847(block, "_inventory", closedTexture, generator.field_22831);
        generator.method_25623(block, inventoryModel);
        class_4925 blockStateSupplier = class_4925.method_25769((class_2248)block);
        blockStateSupplier.method_25775(class_4926.method_25784((class_2769)CargoBoxBlock.field_10927, (class_2769)CargoBoxBlock.OPEN).method_25800((facing, open) -> this.rotateForFace(this.model(open != false ? openModel : closedModel), (class_2350)facing, false)));
        generator.field_22830.accept(blockStateSupplier);
    }

    private void registerGlassPanel(class_4910 generator, class_2248 block) {
        generator.method_25556(block, "_trim");
        class_4944 textureMap = new class_4944().method_25868(class_4945.field_23031, class_4944.method_25860((class_2248)block)).method_25868(class_4945.field_23032, class_4944.method_25866((class_2248)block, (String)"_trim"));
        class_2960 model = GLASS_PANEL.method_25846(block, textureMap, generator.field_22831);
        generator.field_22830.accept(class_4925.method_25770((class_2248)block, (class_4935)this.model(model)).method_25775((class_4926)class_4926.method_25783((class_2769)class_2741.field_12525).method_25793((Comparable)class_2350.field_11036, this.variant(class_4936.field_22885, class_4936.class_4937.field_22891)).method_25793((Comparable)class_2350.field_11033, this.variant(class_4936.field_22885, class_4936.class_4937.field_22893)).method_25793((Comparable)class_2350.field_11035, this.variant()).method_25793((Comparable)class_2350.field_11043, this.variant(class_4936.field_22886, class_4936.class_4937.field_22892)).method_25793((Comparable)class_2350.field_11034, this.variant(class_4936.field_22886, class_4936.class_4937.field_22893)).method_25793((Comparable)class_2350.field_11039, this.variant(class_4936.field_22886, class_4936.class_4937.field_22891))));
    }

    private void registerCullingGlass(class_4910 generator) {
        class_2248 block = WatheBlocks.CULLING_GLASS;
        generator.method_25600(block);
        class_2960 model = class_4941.method_25842((class_2248)block);
        generator.field_22830.accept(class_4925.method_25770((class_2248)block, (class_4935)this.model(model)).method_25775((class_4926)class_4926.method_25783((class_2769)class_2741.field_12525).method_25793((Comparable)class_2350.field_11036, this.variant(class_4936.field_22885, class_4936.class_4937.field_22891)).method_25793((Comparable)class_2350.field_11033, this.variant(class_4936.field_22885, class_4936.class_4937.field_22893)).method_25793((Comparable)class_2350.field_11035, this.variant()).method_25793((Comparable)class_2350.field_11043, this.variant(class_4936.field_22886, class_4936.class_4937.field_22892)).method_25793((Comparable)class_2350.field_11034, this.variant(class_4936.field_22886, class_4936.class_4937.field_22893)).method_25793((Comparable)class_2350.field_11039, this.variant(class_4936.field_22886, class_4936.class_4937.field_22891))));
    }

    private void registerHorizontalAxisBlock(class_4910 generator, class_2248 block, boolean registerInventoryParent) {
        class_2960 model = class_4941.method_25842((class_2248)block);
        if (registerInventoryParent) {
            generator.method_25623(block, model);
        }
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775((class_4926)class_4926.method_25783(PanelStripesBlock.AXIS).method_25793((Comparable)class_2350.class_2351.field_11048, this.model(model).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25793((Comparable)class_2350.class_2351.field_11051, this.model(model))));
    }

    private void registerButton(class_4910 generator, class_2248 block) {
        class_2960 model = class_4941.method_25842((class_2248)block);
        class_2960 pressedModel = class_4941.method_25843((class_2248)block, (String)"_pressed");
        generator.method_25623(block, model);
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775(this.wallMountedVariantMap(class_2269.field_10729, pressedModel, model)));
    }

    private void registerCulledBlock(class_4910 generator, class_2248 block, class_2248 textureBlock) {
        class_2960 model = class_4943.field_22937.method_25846(block, class_4944.method_25872((class_2248)textureBlock), generator.field_22831);
        class_2960 modelGlass = class_4943.field_22937.method_25847(block, "_glass", class_4944.method_25869((class_2960)class_4944.method_25860((class_2248)WatheBlocks.HULL_GLASS)), generator.field_22831);
        class_4943.field_22938.method_25852(class_4941.method_25840((class_1792)block.method_8389()), class_4944.method_25911((class_2248)textureBlock), generator.field_22831);
        class_4922 blockStateSupplier = class_4922.method_25758((class_2248)block);
        for (class_2350 direction : class_2350.values()) {
            blockStateSupplier.method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2429.field_11329.get(direction), (Comparable)Boolean.valueOf(true)), this.rotateForFace(this.model(model), direction, true));
            blockStateSupplier.method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2429.field_11329.get(direction), (Comparable)Boolean.valueOf(false)), this.rotateForFace(this.model(modelGlass), direction, true));
        }
        generator.field_22830.accept(blockStateSupplier);
    }

    private void registerOrnament(class_4910 generator, class_2248 block) {
        class_4944 allTexture = class_4944.method_25869((class_2960)class_4944.method_25866((class_2248)block, (String)"_all"));
        class_4944 endTexture = class_4944.method_25869((class_2960)class_4944.method_25866((class_2248)block, (String)"_end"));
        class_4944 sideTexture = class_4944.method_25869((class_2960)class_4944.method_25866((class_2248)block, (String)"_side"));
        class_4944 cornerTexture = class_4944.method_25869((class_2960)class_4944.method_25866((class_2248)block, (String)"_corner"));
        class_4944 sidesTexture = class_4944.method_25869((class_2960)class_4944.method_25866((class_2248)block, (String)"_sides"));
        class_4944 centerTexture = class_4944.method_25869((class_2960)class_4944.method_25866((class_2248)block, (String)"_center"));
        class_4944 sidesCenterTexture = class_4944.method_25869((class_2960)class_4944.method_25866((class_2248)block, (String)"_sides_center"));
        ORNAMENT_R0.method_25847(block, "_all", allTexture, generator.field_22831);
        ORNAMENT_R0.method_25847(block, "_center", centerTexture, generator.field_22831);
        ORNAMENT_R0.method_25847(block, "_left_right_center", sidesCenterTexture, generator.field_22831);
        ORNAMENT_R0.method_25847(block, "_left", sideTexture, generator.field_22831);
        ORNAMENT_R90.method_25847(block, "_top", sideTexture, generator.field_22831);
        ORNAMENT_R180.method_25847(block, "_right", sideTexture, generator.field_22831);
        ORNAMENT_R270.method_25847(block, "_bottom", sideTexture, generator.field_22831);
        ORNAMENT_R0.method_25847(block, "_left_bottom", cornerTexture, generator.field_22831);
        ORNAMENT_R90.method_25847(block, "_left_top", cornerTexture, generator.field_22831);
        ORNAMENT_R180.method_25847(block, "_right_top", cornerTexture, generator.field_22831);
        ORNAMENT_R270.method_25847(block, "_right_bottom", cornerTexture, generator.field_22831);
        ORNAMENT_R0.method_25847(block, "_left_right", sidesTexture, generator.field_22831);
        ORNAMENT_R90.method_25847(block, "_top_bottom", sidesTexture, generator.field_22831);
        ORNAMENT_R0.method_25847(block, "_left_right_top", endTexture, generator.field_22831);
        ORNAMENT_R90.method_25847(block, "_right_top_bottom", endTexture, generator.field_22831);
        ORNAMENT_R180.method_25847(block, "_left_right_bottom", endTexture, generator.field_22831);
        ORNAMENT_R270.method_25847(block, "_left_top_bottom", endTexture, generator.field_22831);
        generator.method_25556(block, "_all");
        class_4926 map = class_4926.method_25784((class_2769)OrnamentBlock.field_10927, OrnamentBlock.SHAPE).method_25800((facing, shape) -> this.rotateForFace(this.model(class_4941.method_25843((class_2248)block, (String)("_" + shape.method_15434()))), (class_2350)facing, false));
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775(map));
    }

    private void registerSpaceHelmet(class_4910 generator, class_2248 block) {
        generator.method_25538(block.method_8389(), class_2960.method_60656((String)"item/template_skull"));
        class_2960 model = class_4943.field_22908.method_25846(block, class_4944.method_25901((class_2248)WatheBlocks.STAINLESS_STEEL), generator.field_22831);
        generator.field_22830.accept(class_4910.method_25644((class_2248)block, (class_2960)model));
    }

    private void registerHullGlass(class_4910 generator, class_2248 block) {
        class_2960 model = class_4943.field_22972.method_25846(block, class_4944.method_25864((class_2248)block), generator.field_22831);
        class_2960 opaqueModel = class_4943.field_22972.method_25847(block, "_opaque", class_4944.method_25875((class_2960)class_4944.method_25866((class_2248)block, (String)"_opaque")), generator.field_22831);
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775(class_4910.method_25565((class_2746)PrivacyGlassBlock.OPAQUE, (class_2960)opaqueModel, (class_2960)model)));
        generator.method_25623(block, model);
    }

    private void registerPrivacyGlassPanel(class_4910 generator, class_2248 block) {
        generator.method_25556(block, "_trim");
        class_4944 textureMap = new class_4944().method_25868(class_4945.field_23031, class_4944.method_25860((class_2248)block)).method_25868(class_4945.field_23032, class_4944.method_25866((class_2248)block, (String)"_trim"));
        class_4944 opaqueTextureMap = new class_4944().method_25868(class_4945.field_23031, class_4944.method_25866((class_2248)block, (String)"_opaque")).method_25868(class_4945.field_23032, class_4944.method_25866((class_2248)block, (String)"_trim"));
        class_2960 model = GLASS_PANEL.method_25846(block, textureMap, generator.field_22831);
        class_2960 opaqueModel = GLASS_PANEL.method_25847(block, "_opaque", opaqueTextureMap, generator.field_22831);
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775((class_4926)class_4926.method_25784((class_2769)class_2741.field_12525, (class_2769)PrivacyGlassPanelBlock.OPAQUE).method_25797((Comparable)class_2350.field_11036, (Comparable)Boolean.valueOf(true), this.variant(opaqueModel, class_4936.field_22885, class_4936.class_4937.field_22891)).method_25797((Comparable)class_2350.field_11036, (Comparable)Boolean.valueOf(false), this.variant(model, class_4936.field_22885, class_4936.class_4937.field_22891)).method_25797((Comparable)class_2350.field_11033, (Comparable)Boolean.valueOf(true), this.variant(opaqueModel, class_4936.field_22885, class_4936.class_4937.field_22893)).method_25797((Comparable)class_2350.field_11033, (Comparable)Boolean.valueOf(false), this.variant(model, class_4936.field_22885, class_4936.class_4937.field_22893)).method_25797((Comparable)class_2350.field_11035, (Comparable)Boolean.valueOf(true), this.model(opaqueModel)).method_25797((Comparable)class_2350.field_11035, (Comparable)Boolean.valueOf(false), this.model(model)).method_25797((Comparable)class_2350.field_11043, (Comparable)Boolean.valueOf(true), this.variant(opaqueModel, class_4936.field_22886, class_4936.class_4937.field_22892)).method_25797((Comparable)class_2350.field_11043, (Comparable)Boolean.valueOf(false), this.variant(model, class_4936.field_22886, class_4936.class_4937.field_22892)).method_25797((Comparable)class_2350.field_11034, (Comparable)Boolean.valueOf(true), this.variant(opaqueModel, class_4936.field_22886, class_4936.class_4937.field_22893)).method_25797((Comparable)class_2350.field_11034, (Comparable)Boolean.valueOf(false), this.variant(model, class_4936.field_22886, class_4936.class_4937.field_22893)).method_25797((Comparable)class_2350.field_11039, (Comparable)Boolean.valueOf(true), this.variant(opaqueModel, class_4936.field_22886, class_4936.class_4937.field_22891)).method_25797((Comparable)class_2350.field_11039, (Comparable)Boolean.valueOf(false), this.variant(model, class_4936.field_22886, class_4936.class_4937.field_22891))));
    }

    private void registerRailing(class_4910 generator, class_2248 block, class_2248 post, class_2248 diagonal) {
        class_2960 model = class_4941.method_25842((class_2248)block);
        class_2960 inventoryModel = class_4941.method_25843((class_2248)block, (String)"_inventory");
        class_2960 diagonalLeftModel = class_4941.method_25843((class_2248)block, (String)"_diagonal_left");
        class_2960 diagonalRightModel = class_4941.method_25843((class_2248)block, (String)"_diagonal_right");
        class_2960 diagonalTopLeftModel = class_4941.method_25843((class_2248)block, (String)"_diagonal_top_left");
        class_2960 diagonalTopRightModel = class_4941.method_25843((class_2248)block, (String)"_diagonal_top_right");
        class_2960 diagonalBottomLeftModel = class_4941.method_25843((class_2248)block, (String)"_diagonal_bottom_left");
        class_2960 diagonalBottomRightModel = class_4941.method_25843((class_2248)block, (String)"_diagonal_bottom_right");
        class_2960 postModel = class_4941.method_25843((class_2248)block, (String)"_post");
        generator.method_25623(block, inventoryModel);
        generator.field_22830.accept(class_4925.method_25770((class_2248)block, (class_4935)this.model(model)).method_25775(class_4910.method_25599()));
        generator.field_22830.accept(class_4925.method_25770((class_2248)post, (class_4935)this.model(postModel)).method_25775(class_4910.method_25599()));
        generator.field_22830.accept(class_4925.method_25769((class_2248)diagonal).method_25775(class_4926.method_25785((class_2769)DiagonalRailingBlock.field_11177, (class_2769)DiagonalRailingBlock.LEFT, DiagonalRailingBlock.SHAPE).method_25805((facing, left, shape) -> {
            class_4935 variant = this.model(switch (shape) {
                default -> throw new MatchException(null, null);
                case RailingShape.TOP -> {
                    if (left.booleanValue()) {
                        yield diagonalTopLeftModel;
                    }
                    yield diagonalTopRightModel;
                }
                case RailingShape.MIDDLE -> {
                    if (left.booleanValue()) {
                        yield diagonalLeftModel;
                    }
                    yield diagonalRightModel;
                }
                case RailingShape.BOTTOM -> left != false ? diagonalBottomLeftModel : diagonalBottomRightModel;
            });
            return this.rotateForFace(variant, left != false ? facing : facing.method_10153(), false);
        })));
    }

    private void registerBed(class_4910 generator, class_2248 block) {
        class_4944 textureMap = class_4944.method_25872((class_2248)block);
        class_2960 inventoryModel = TRIMMED_BED_INVENTORY.method_25846(block, textureMap, generator.field_22831);
        class_2960 headModel = TRIMMED_BED_HEAD.method_25846(block, textureMap, generator.field_22831);
        class_2960 footModel = TRIMMED_BED_FOOT.method_25846(block, textureMap, generator.field_22831);
        generator.method_25623(block, inventoryModel);
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775(class_4926.method_25784((class_2769)TrimmedBedBlock.field_11177, (class_2769)TrimmedBedBlock.field_9967).method_25800((facing, part) -> this.rotateForFace(this.model(part == class_2742.field_12560 ? headModel : footModel), (class_2350)facing, false))));
    }

    private void registerPipe(class_4910 generator, class_2248 block) {
        class_4944 textureMap = new class_4944().method_25868(class_4945.field_23015, class_4944.method_25866((class_2248)block, (String)"_top")).method_25868(class_4945.field_23014, class_4944.method_25866((class_2248)block, (String)"_top")).method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)block, (String)"_side"));
        class_2960 model = CARGO_BOX.method_25846(block, textureMap, generator.field_22831);
        class_2960 inventoryModel = class_4943.field_22977.method_25847(block, "_inventory", textureMap, generator.field_22831);
        generator.method_25623(block, inventoryModel);
        generator.field_22830.accept(class_4925.method_25770((class_2248)block, (class_4935)this.model(model)).method_25775(class_4910.method_25640()));
    }

    private void registerPump(class_4910 generator, class_2248 block) {
        class_2960 model = class_4941.method_25842((class_2248)block);
        generator.method_25623(block, model);
        generator.field_22830.accept(class_4925.method_25770((class_2248)block, (class_4935)this.model(model)).method_25775(class_4910.method_25640()));
    }

    private void registerVentHatch(class_4910 generator, class_2248 block) {
        class_4944 textureMap = class_4944.method_25872((class_2248)block);
        class_2960 model = VENT_HATCH.method_25846(block, textureMap, generator.field_22831);
        class_2960 openModel = VENT_HATCH_OPEN.method_25846(block, textureMap, generator.field_22831);
        generator.method_25600(block);
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775(this.wallMountedVariantMap(VentHatchBlock.OPEN, openModel, model)));
    }

    private void registerNeonPillar(class_4910 generator, class_2248 block, boolean hasEmergencyVariant) {
        class_4944 litTextureMap = new class_4944().method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)block, (String)"_lit")).method_25868(class_4945.field_23013, class_4944.method_25866((class_2248)block, (String)"_top_lit")).method_25868(class_4945.field_23012, class_4944.method_25866((class_2248)block, (String)"_lit"));
        class_4944 unlitTextureMap = new class_4944().method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)block, (String)"_unlit")).method_25868(class_4945.field_23013, class_4944.method_25866((class_2248)block, (String)"_top_unlit")).method_25868(class_4945.field_23012, class_4944.method_25866((class_2248)block, (String)"_unlit"));
        class_4944 unpoweredTextureMap = hasEmergencyVariant ? new class_4944().method_25868(class_4945.field_23018, class_4944.method_25866((class_2248)block, (String)"_emergency")).method_25868(class_4945.field_23013, class_4944.method_25866((class_2248)block, (String)"_top_emergency")).method_25868(class_4945.field_23012, class_4944.method_25866((class_2248)block, (String)"_emergency")) : unlitTextureMap;
        class_2960 litModel = class_4943.field_22974.method_25847(block, "_lit", litTextureMap, generator.field_22831);
        class_2960 litHorizontalModel = class_4943.field_22975.method_25847(block, "_lit", litTextureMap, generator.field_22831);
        class_2960 unlitModel = class_4943.field_22974.method_25847(block, "_unlit", unlitTextureMap, generator.field_22831);
        class_2960 unlitHorizontalModel = class_4943.field_22975.method_25847(block, "_unlit", unlitTextureMap, generator.field_22831);
        class_2960 unpoweredModel = hasEmergencyVariant ? class_4943.field_22974.method_25847(block, "_emergency", unpoweredTextureMap, generator.field_22831) : unlitModel;
        class_2960 unpoweredHorizontalModel = hasEmergencyVariant ? class_4943.field_22975.method_25847(block, "_emergency", unpoweredTextureMap, generator.field_22831) : unlitHorizontalModel;
        generator.method_25623(block, unlitModel);
        class_4926 map = class_4926.method_25785((class_2769)NeonPillarBlock.field_11459, (class_2769)NeonPillarBlock.ACTIVE, (class_2769)NeonPillarBlock.LIT).method_25805((axis, powered, lit) -> {
            if (axis == class_2350.class_2351.field_11052) {
                return this.model(powered.booleanValue() ? (lit.booleanValue() ? litModel : unlitModel) : unpoweredModel);
            }
            class_4935 variant = this.model(powered.booleanValue() ? (lit.booleanValue() ? litHorizontalModel : unlitHorizontalModel) : unpoweredHorizontalModel).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891);
            if (axis == class_2350.class_2351.field_11048) {
                return variant.method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891);
            }
            return variant;
        });
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775(map));
    }

    private void registerNeonTube(class_4910 generator, class_2248 block, boolean hasEmergencyVariant) {
        class_4944 textureMap = new class_4944().method_25868(class_4945.field_23011, class_4944.method_25866((class_2248)block, (String)"_lit"));
        class_4944 unlitTextureMap = new class_4944().method_25868(class_4945.field_23011, class_4944.method_25866((class_2248)block, (String)"_unlit"));
        class_2960 model = THICK_BAR.method_25846(block, textureMap, generator.field_22831);
        class_2960 unlitModel = THICK_BAR.method_25847(block, "_unlit", unlitTextureMap, generator.field_22831);
        class_4944 unpoweredTextureMap = new class_4944().method_25868(class_4945.field_23011, class_4944.method_25866((class_2248)block, (String)"_emergency"));
        class_2960 unpoweredModel = hasEmergencyVariant ? THICK_BAR.method_25847(block, "_emergency", unpoweredTextureMap, generator.field_22831) : unlitModel;
        class_2960 topModel = THICK_BAR_TOP.method_25846(block, textureMap, generator.field_22831);
        class_2960 bottomModel = THICK_BAR_BOTTOM.method_25846(block, textureMap, generator.field_22831);
        generator.method_25537(block.method_8389());
        class_4922 blockStateSupplier = class_4922.method_25758((class_2248)block);
        for (class_2350.class_2351 axis : class_2350.class_2351.values()) {
            for (Boolean lit : NeonTubeBlock.LIT.method_11898()) {
                for (Boolean powered : NeonTubeBlock.ACTIVE.method_11898()) {
                    blockStateSupplier.method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)BarBlock.field_11459, (Comparable)axis).method_25751((class_2769)NeonTubeBlock.ACTIVE, (Comparable)powered).method_25751((class_2769)NeonTubeBlock.LIT, (Comparable)lit), this.rotateForAxis(this.model(powered.booleanValue() ? (lit.booleanValue() ? model : unlitModel) : unpoweredModel), axis)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)BarBlock.field_11459, (Comparable)axis).method_25751((class_2769)BarBlock.TOP, (Comparable)Boolean.valueOf(true)), this.rotateForAxis(this.model(topModel), axis)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)BarBlock.field_11459, (Comparable)axis).method_25751((class_2769)BarBlock.BOTTOM, (Comparable)Boolean.valueOf(true)), this.rotateForAxis(this.model(bottomModel), axis));
                }
            }
        }
        generator.field_22830.accept(blockStateSupplier);
    }
}

